// Title      : Post.java
// Author     : James Baird
// Created    : Sunday, 4th November 2001
// Description: Post Class

import java.io.FileWriter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Post extends DefaultHandler
{
  public Post(String group, String id, String structure)
  {
    this.group = group;
    this.id = id;
    this.structure = structure;
  }
  
  public String getGroup()
  {
    return group;
  }
  
  public String getId()
  {
    return id;
  }
  
  public void getPotentialReplies(FileWriter outfile, String xmlfilepath)
  {
    try
    {
      this.outfile = outfile;

      SAXParserFactory factory = SAXParserFactory.newInstance();

      SAXParser parser = factory.newSAXParser();

      XMLReader xmlReader = parser.getXMLReader();

      xmlReader.setContentHandler(this);

      System.out.println(xmlfilepath + "/" + group + ".xml");

      xmlReader.parse(xmlfilepath + "/" + group + ".xml");      

      this.outfile = null;
    }
    catch (ParserConfigurationException e)
    {
      e.printStackTrace();
    }
    catch (SAXException e)
    {
      e.printStackTrace();
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }
  
  public void startDocument() throws SAXException
  {
    state = "seekInitial";
  }

  public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException
  {
    try
    {
      if (qName.equals("post"))
      {
        if (state.equals("seekInitial"))
        {
          if (attributes.getValue("id").equals(id))
          {
            initialSubject = attributes.getValue("subject");
            subject = initialSubject;

            outfile.write("*** POST group " + group + " vol " + volume + " id " + attributes.getValue("id") + " len " + attributes.getValue("length") + System.getProperty("line.separator"));

            state = "extractPosts";
          }
        }
        else if (state.equals("extractPosts"))
        {
          subject = attributes.getValue("subject");

          if (subject.indexOf(initialSubject) != -1)
            outfile.write("*** REPLY id " + attributes.getValue("id") + " len " + attributes.getValue("length") + System.getProperty("line.separator"));
        }
      }
      else if (qName.equals("group"))
        volume = attributes.getValue("volume");
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }
  
  public void endElement(String uri, String localName, String qName) throws SAXException
  {
    try
    {
      if (state.equals("extractPosts") && subject.indexOf(initialSubject) != -1)
        if (qName.equals("paragraph"))
          outfile.write(System.getProperty("line.separator"));
        else if (qName.equals("header"))
          outfile.write("---" + System.getProperty("line.separator"));
        else if (qName.equals("post"))
          outfile.write(System.getProperty("line.separator"));
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }

  public void characters(char[] ch, int start, int length) throws SAXException
  {
    try
    {
      if (state.equals("extractPosts") && subject.indexOf(initialSubject) != -1)
        outfile.write(new String(ch, start, length));
    }
    catch (IOException e)
    {
      e.printStackTrace();
    }
  }

  FileWriter outfile;
  String group;
  String id;
  String structure;
  String state;
  String initialSubject;
  String subject;
  String volume;
}
